clc;clear all;close all;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GECAD CEC/GECCO 2026 Competition: Evolutionary Computation in the Energy Domain: 2026 Edition of the fair-price scheduling
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath('functions') %Necessary functions to run the algorithms (encrypted)

tTotalTime=tic; % lets track total computational time

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Load Data base 
[caseStudyData, DB_name]=callDatabase();

Select_algorithm=1;
%1: HyDE algorithm (test algorithm)
%2: Your algorithm
%%%%%%%%%%%%%%%%%% FEs %%%%%%%%%%%%%%%%%%
No_evals=5000; %Number of function evaluations % This are the number of function evaluations per trial. The lower the value, more points for the algorithm!
noRuns=20; %this can be changed but final results should be based on 20 trials

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if No_evals > 5000
  error('5,000 evaluations is the maximum number allowed!');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Load MH parameters (e.g., get MH parameters from DEparameters.m file)
switch Select_algorithm
       case 1
          addpath('HyDE')
          algorithm='HyDE-Algorithm'; %'The participants should include their algorithm here'
          DEparameters %Function defined by the participant
          No_solutions=deParameters.I_NP; %Notice that some algorithms are limited to one individual
       case 2
          %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
          %%%%%%%%%%%%%%%%%%%%%% Your algorithm %%%%%%%%%%%%%%%%%%%%%%%%%%%

    otherwise
          fprintf(1,'No algorithm selected\n');
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Label of the algorithm and the case study
Tag.algorithm=algorithm;
Tag.DB=DB_name;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Set other parameters
otherParameters =setOtherParameters(caseStudyData, No_solutions);

%% Set lower/upper bounds of variables 
[lowerB,upperB] = setVariablesBounds(caseStudyData,otherParameters);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Call the MH for optimizationclear 
ResDB=struc([]);
for iRuns=1:noRuns %Number of trails
    tOpt=tic;
    rand('state',sum(noRuns*100*clock))% ensure stochastic indpt trials
    otherParameters.iRuns=iRuns;      

    switch Select_algorithm
        case 1
            [ResDB(iRuns).Fit_and_p, ...
            ResDB(iRuns).sol, ...
            ResDB(iRuns).fitVector]= ...                   
            HyDE(deParameters,caseStudyData,otherParameters,lowerB,upperB,No_evals);
        case 2     
          %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
          %%%%%%%%%%%%%%%%%%%%%% Your algorithm %%%%%%%%%%%%%%%%%%%%%%%%%%%

    end 
        ResDB(iRuns).noEvals=No_evals;
        ResDB(iRuns).tOpt=toc(tOpt); % time of each trial

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %% Save the results and stats
        Save_results

end

%% End of MH Optimization
% for j=1:noRuns
%     lower_violations=ResDB(j).sol<lowerB;
%     upper_violations=ResDB(j).sol>upperB;
%     many_low(j)=sum(lower_violations);
%     many_up(j)=sum(upper_violations);
%     fprintf('lower_violations : %d .\n', many_low(j));
%     fprintf('upper_violations : %d .\n', many_up(j));
% end

tTotalTime=toc(tTotalTime); %Total time

% best run index and solution
allFit = arrayfun(@(s) s.Fit_and_p(1), ResDB);
[bestFitness, idxBestRun] = min(allFit);
bestPrices = ResDB(idxBestRun).sol;
%plot(bestPrices)

% evaluate that best solution once
clear fitnessFun_fairLECprice
[~, bills_best] = fitnessFun_fairLECprice(bestPrices, caseStudyData, otherParameters, 1)

% std of total bills across households (annual bills)
stdBills = std(bills_best.bill, 0, 2);   % scalar

fprintf('\n===== GLOBAL BEST OVER %d RUNS =====\n', noRuns);
fprintf('Best run index          : %d\n', idxBestRun);
fprintf('Best fitness (objective): %.6f\n', bestFitness);
fprintf('Std of household bills  : %.6f\n', stdBills);
